<?php
/**
 * LUXOR IPTV - Log Connection Results
 *
 * Called by the app to log which server was used and if login succeeded
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../includes/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Get POST data
$input = json_decode(file_get_contents('php://input'), true);

$deviceId = $input['device_id'] ?? null;
$serverId = $input['server_id'] ?? null;
$username = $input['username'] ?? null;
$status = $input['status'] ?? 'success';

if (!$deviceId) {
    http_response_code(400);
    echo json_encode(['error' => 'device_id required']);
    exit;
}

try {
    db()->insert('connection_logs', [
        'device_id' => $deviceId,
        'server_used' => $serverId ? (int)$serverId : null,
        'username' => $username,
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'status' => in_array($status, ['success', 'failed']) ? $status : 'success'
    ]);

    echo json_encode(['success' => true]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Server error']);
}
